# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 5
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR5_strategy.txt
# LLM Suggested Fallback: C

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR5(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"
    
    current_round = len(my_history) + 1
    
    # Check for hard-coded defection in opponent's code
    if "return \"D\"" in opponent_program_code or "return 'D'" in opponent_program_code:
        return "D"
    
    # Initial rounds (1-3): Cooperate
    if current_round <= 3:
        return "C"
    
    # Mid rounds (4-7): Modified Tit-for-Tat or Tit-for-Two-Tats
    if 4 <= current_round <= 7:
        # Check opponent's behavior in first 3 rounds
        early_defects = opp_history[:3].count("D")
        if early_defects <= 1:
            # Mostly cooperative, continue cooperating unless two consecutive defections
            if len(opp_history) >= 2 and opp_history[-1] == "D" and opp_history[-2] == "D":
                return "D"
            else:
                return "C"
        else:
            # More defections, switch to Tit-for-Two-Tats
            if len(opp_history) >= 2 and opp_history[-1] == "D" and opp_history[-2] == "D":
                return "D"
            else:
                return "C"
    
    # Late rounds (8-10): Adapt based on opponent's behavior
    if current_round >= 8:
        total_defects = opp_history.count("D")
        total_cooperations = len(opp_history) - total_defects
        if total_defects > total_cooperations:
            return "D"
        else:
            return "C"
    
    # Default to cooperate if no other condition is met
    return "C"